<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Inertia\Inertia;
use App\Models\Product;
use App\Models\Order;
use App\Models\User;

class AdminDashboardController extends Controller
{
    /**
     * Handle the incoming request.
     */
    public function __invoke()
    {
        $stats = [
            'total_products' => Product::count(),
            'total_stock_quantity' => Product::sum('stock_quantity'),
            'total_orders' => Order::where('soft_delete', 0)->count(),
            'total_users' => User::count(),
        ];
        
        return Inertia::render('Admin/Dashboard', ['stats' => $stats]);
    }
}
