<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use App\Models\User;
use Illuminate\Http\Request;
use Inertia\Inertia;

class NotificationController extends Controller
{
    public function index()
    {
        $notifications = Notification::with('user')
            ->latest()
            ->paginate(15);
            
        return Inertia::render('Admin/Notifications/Index', compact('notifications'));
    }

    public function create()
    {
        $users = User::select('id', 'name', 'email')->get();
        return Inertia::render('Admin/Notifications/Create', compact('users'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required|in:order,deal,product,general',
            'title' => 'required|string|max:255',
            'message' => 'required|string',
            'user_id' => 'nullable|exists:users,id',
            'send_to_all' => 'boolean'
        ]);

        if ($request->send_to_all) {
            User::chunk(100, function ($users) use ($request) {
                foreach ($users as $user) {
                    Notification::create([
                        'user_id' => $user->id,
                        'type' => $request->type,
                        'title' => $request->title,
                        'message' => $request->message,
                        'data' => $request->data ? json_decode($request->data, true) : null
                    ]);
                }
            });
        } else {
            Notification::create([
                'user_id' => $request->user_id,
                'type' => $request->type,
                'title' => $request->title,
                'message' => $request->message,
                'data' => $request->data ? json_decode($request->data, true) : null
            ]);
        }

        return redirect()->route('admin.notifications.index');
    }

    public function destroy(Notification $notification)
    {
        $notification->delete();
        return redirect()->route('admin.notifications.index');
    }
}