<?php

namespace App\Http\Controllers;

use App\Models\ShippingAddress;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ShippingAddressController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'first_name' => 'required|string|max:255',
            'last_name' => 'required|string|max:255',
            'address_line_1' => 'required|string|max:255',
            'address_line_2' => 'nullable|string|max:255',
            'city' => 'required|string|max:255',
            'state' => 'required|string|max:255',
            'country' => 'required|string|max:255',
            'zip_code' => 'required|string|max:20',
            'phone' => 'nullable|string|max:20',
            'is_default' => 'boolean'
        ]);

        if ($request->is_default) {
            ShippingAddress::where('user_id', Auth::id())->update(['is_default' => false]);
        }

        ShippingAddress::create([
            'user_id' => Auth::id(),
            ...$request->only([
                'first_name', 'last_name', 'address_line_1', 'address_line_2',
                'city', 'state', 'country', 'zip_code', 'phone', 'is_default'
            ])
        ]);

        return back()->with('success', 'Address added successfully.');
    }

    public function destroy(ShippingAddress $shippingAddress)
    {
        if ($shippingAddress->user_id !== Auth::id()) {
            abort(403);
        }

        $shippingAddress->delete();
        return back()->with('success', 'Address deleted successfully.');
    }
}
