@extends('frontend.home')
@section('content')
<main>
    <div class="container my-5">
        <div class="row">
            <div class="col-12">
                <div class="d-flex align-items-center justify-content-between mb-4">
                    <h1 class="h3 mb-0">Your Orders</h1>
                    <div class="d-flex gap-3">
                        <select class="form-select form-select-sm" style="width: auto;">
                            <option>Last 30 days</option>
                            <option>Last 3 months</option>
                            <option>2024</option>
                            <option>2023</option>
                        </select>
                        <input type="search" class="form-control form-control-sm" placeholder="Search all orders" style="width: 250px;">
                    </div>
                </div>

                @if($orders->count() > 0)
                    @foreach($orders as $order)
                    <div class="card mb-4 border">
                        <div class="card-header bg-light py-3">
                            <div class="row align-items-center">
                                <div class="col-md-3">
                                    <div class="small text-muted">ORDER PLACED</div>
                                    <div class="fw-bold">{{ $order->created_at->format('M d, Y') }}</div>
                                </div>
                                <div class="col-md-2">
                                    <div class="small text-muted">TOTAL</div>
                                    <div class="fw-bold">৳{{ number_format($order->total_amount, 2) }}</div>
                                </div>
                                <div class="col-md-3">
                                    <div class="small text-muted">SHIP TO</div>
                                    <div class="fw-bold text-truncate">{{ $order->customer_name }}</div>
                                </div>
                                <div class="col-md-4 text-end">
                                    <div class="small text-muted">ORDER # {{ $order->order_number }}</div>
                                    <div class="mt-1">
                                        <a href="#" class="text-decoration-none me-3">View order details</a>
                                        <a href="#" class="text-decoration-none">Invoice</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="d-flex align-items-center mb-3">
                                        @php
                                            $statusColor = match($order->status) {
                                                'delivered' => 'success',
                                                'shipped' => 'info',
                                                'processing' => 'warning',
                                                'cancelled' => 'danger',
                                                default => 'secondary'
                                            };
                                        @endphp
                                        <span class="badge bg-{{ $statusColor }} me-2">{{ ucfirst($order->status) }}</span>
                                        <span class="text-muted">
                                            @if($order->status == 'delivered')
                                                Delivered {{ $order->updated_at->format('M d') }}
                                            @elseif($order->status == 'shipped')
                                                Shipped {{ $order->updated_at->format('M d') }}
                                            @else
                                                {{ ucfirst($order->status) }}
                                            @endif
                                        </span>
                                    </div>
                                    
                                    @foreach($order->orderItems->take(3) as $item)
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="me-3">
                                            @if($item->product->image)
                                                <img src="{{ asset('storage/' . $item->product->image) }}" 
                                                     alt="{{ $item->product->name }}" 
                                                     class="rounded" 
                                                     style="width: 60px; height: 60px; object-fit: cover;">
                                            @else
                                                <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                                     style="width: 60px; height: 60px;">
                                                    <i class="bi bi-image text-muted"></i>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="flex-grow-1">
                                            <h6 class="mb-1">
                                                <a href="{{ route('product.show', $item->product->id) }}" 
                                                   class="text-decoration-none text-dark">
                                                    {{ $item->product->name }}
                                                </a>
                                            </h6>
                                            <div class="small text-muted">Qty: {{ $item->quantity }}</div>
                                            <div class="small text-muted">৳{{ number_format($item->price, 2) }} each</div>
                                        </div>
                                        <div class="text-end">
                                            @if($order->status == 'delivered')
                                                <button class="btn btn-outline-primary btn-sm mb-1">Buy it again</button>
                                                <br>
                                                <a href="#" class="small text-decoration-none">Write a product review</a>
                                            @elseif($order->status == 'shipped')
                                                <button class="btn btn-outline-secondary btn-sm">Track package</button>
                                            @endif
                                        </div>
                                    </div>
                                    @endforeach
                                    
                                    @if($order->orderItems->count() > 3)
                                    <div class="text-muted small">
                                        and {{ $order->orderItems->count() - 3 }} more items
                                    </div>
                                    @endif
                                </div>
                                <div class="col-md-4">
                                    <div class="border-start ps-4">
                                        <h6 class="mb-3">Order Summary</h6>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span>Items ({{ $order->orderItems->sum('quantity') }}):</span>
                                            <span>৳{{ number_format($order->subtotal, 2) }}</span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span>Shipping & handling:</span>
                                            <span>৳0.00</span>
                                        </div>
                                        <div class="d-flex justify-content-between mb-2">
                                            <span>Tax:</span>
                                            <span>৳0.00</span>
                                        </div>
                                        <hr>
                                        <div class="d-flex justify-content-between fw-bold">
                                            <span>Order total:</span>
                                            <span>৳{{ number_format($order->total_amount, 2) }}</span>
                                        </div>
                                        <div class="mt-3">
                                            <div class="small text-muted">Payment method:</div>
                                            <div>{{ ucfirst(str_replace('_', ' ', $order->payment_method)) }}</div>
                                        </div>
                                        @if($order->delivery_date)
                                        <div class="mt-2">
                                            <div class="small text-muted">Delivery:</div>
                                            <div>{{ ucfirst($order->delivery_date) }} {{ $order->delivery_time }}</div>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach

                    <div class="d-flex justify-content-center mt-4">
                        {{ $orders->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <div class="mb-4">
                            <i class="bi bi-bag-x display-1 text-muted"></i>
                        </div>
                        <h4>No orders yet</h4>
                        <p class="text-muted">You haven't placed any orders yet. Start shopping to see your orders here.</p>
                        <a href="{{ route('shop-all') }}" class="btn btn-primary">Start Shopping</a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</main>
@endsection