@extends('frontend.home')
@section('content')
<main>
    <div class="mt-4">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('shop-all') }}">Shop</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Checkout</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <section class="mb-lg-14 mb-8 mt-8">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <h1 class="fw-bold mb-0">Checkout</h1>
                </div>
            </div>

            <form action="{{ route('place-order') }}" method="POST" id="checkoutForm">
                @csrf
                <div class="row mt-4">
                    <div class="col-lg-7">
                        
                        @guest
                        <!-- Account Information -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="feather-icon icon-user me-2"></i>Account Information</h5>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Name *</label>
                                        <input type="text" name="name" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Email *</label>
                                        <input type="email" name="email" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Password *</label>
                                        <input type="password" name="password" class="form-control" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Confirm Password *</label>
                                        <input type="password" name="password_confirmation" class="form-control" required>
                                    </div>
                                </div>
                                <input type="hidden" name="guest_registration" value="1">
                            </div>
                        </div>
                        @endguest

                        <!-- Delivery Address -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="feather-icon icon-map-pin me-2"></i>Delivery Address</h5>
                            </div>
                            <div class="card-body">
                                @if(auth()->check() && $addresses->count() > 0)
                                    @foreach($addresses as $address)
                                    <div class="form-check mb-3">
                                        <input class="form-check-input" type="radio" name="address_id" value="{{ $address->id }}" id="address{{ $address->id }}" {{ $address->is_default ? 'checked' : '' }}>
                                        <label class="form-check-label" for="address{{ $address->id }}">
                                            <strong>{{ $address->first_name }} {{ $address->last_name }}</strong><br>
                                            {{ $address->address_line_1 }}<br>
                                            {{ $address->city }}, {{ $address->state }}, {{ $address->zip_code }}
                                            @if($address->phone)<br>Phone: {{ $address->phone }}@endif
                                        </label>
                                    </div>
                                    @endforeach
                                @else
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label class="form-label">First Name *</label>
                                            <input type="text" name="first_name" class="form-control" required>
                                        </div>
                                        <div class="col-md-6">
                                            <label class="form-label">Last Name *</label>
                                            <input type="text" name="last_name" class="form-control" required>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Address *</label>
                                            <input type="text" name="address" class="form-control" required>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label">City *</label>
                                            <input type="text" name="city" class="form-control" required>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label">State *</label>
                                            <input type="text" name="state" class="form-control" required>
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label">Zip Code *</label>
                                            <input type="text" name="zip_code" class="form-control" required>
                                        </div>
                                        <div class="col-12">
                                            <label class="form-label">Phone</label>
                                            <input type="text" name="phone" class="form-control">
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Delivery Time -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="feather-icon icon-clock me-2"></i>Delivery Time</h5>
                            </div>
                            <div class="card-body">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label class="form-label">Delivery Date</label>
                                        <select name="delivery_date" class="form-select">
                                            <option value="today">Today</option>
                                            <option value="tomorrow">Tomorrow</option>
                                            <option value="day_after">Day After Tomorrow</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label">Time Slot</label>
                                        <select name="delivery_time" class="form-select">
                                            <option value="9am-12pm">9:00 AM - 12:00 PM</option>
                                            <option value="12pm-3pm">12:00 PM - 3:00 PM</option>
                                            <option value="3pm-6pm">3:00 PM - 6:00 PM</option>
                                            <option value="6pm-9pm">6:00 PM - 9:00 PM</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Delivery Instructions -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="feather-icon icon-message-square me-2"></i>Delivery Instructions</h5>
                            </div>
                            <div class="card-body">
                                <textarea name="delivery_instructions" class="form-control" rows="3" placeholder="Special instructions for delivery (optional)"></textarea>
                            </div>
                        </div>

                        <!-- Payment Method -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="feather-icon icon-credit-card me-2"></i>Payment Method</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="radio" name="payment_method" value="cash_on_delivery" id="cod" checked>
                                    <label class="form-check-label" for="cod">
                                        <strong>Cash on Delivery</strong><br>
                                        <small class="text-muted">Pay when your order is delivered</small>
                                    </label>
                                </div>
                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="radio" name="payment_method" value="bkash" id="bkash">
                                    <label class="form-check-label" for="bkash">
                                        <strong>bKash</strong><br>
                                        <small class="text-muted">Pay using bKash mobile banking</small>
                                    </label>
                                </div>
                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="radio" name="payment_method" value="nagad" id="nagad">
                                    <label class="form-check-label" for="nagad">
                                        <strong>Nagad</strong><br>
                                        <small class="text-muted">Pay using Nagad mobile banking</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                    </div>

                    <!-- Order Summary -->
                    <div class="col-lg-5">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">Order Summary</h5>
                            </div>
                            <div class="card-body">
                                @php $subtotal = 0; @endphp
                                @foreach($cart as $key => $item)
                                @php $subtotal += $item['price'] * $item['quantity']; @endphp
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div class="d-flex align-items-center">
                                        <img src="{{ asset('storage/' . $item['image']) }}" alt="{{ $item['name'] }}" class="img-fluid me-3" style="width: 50px; height: 50px; object-fit: cover;">
                                        <div>
                                            <h6 class="mb-0">{{ $item['name'] }}</h6>
                                            @if($item['weight'])
                                            <small class="text-muted">{{ $item['weight'] }}</small>
                                            @endif
                                            <div><small>Qty: {{ $item['quantity'] }}</small></div>
                                        </div>
                                    </div>
                                    <div class="fw-bold">৳{{ number_format($item['price'] * $item['quantity'], 2) }}</div>
                                </div>
                                @endforeach
                                
                                <hr>
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Subtotal:</span>
                                    <span class="fw-bold">৳{{ number_format($subtotal, 2) }}</span>
                                </div>
                                <div class="d-flex justify-content-between mb-2">
                                    <span>Delivery Fee:</span>
                                    <span class="fw-bold">Free</span>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <span class="h5">Total:</span>
                                    <span class="h5 fw-bold">৳{{ number_format($subtotal, 2) }}</span>
                                </div>
                                
                                <button type="submit" class="btn btn-primary w-100 mt-4">
                                    <i class="feather-icon icon-shopping-bag me-2"></i>Place Order
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </section>
</main>
@endsection