<!DOCTYPE html>
<html lang="en">
   
<!-- Mirrored from freshcart.codescandy.com/pages/index-5.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 06 May 2025 11:01:15 GMT -->
<head>
      <!-- Required meta tags -->
      <meta charset="utf-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
      <meta content="Codescandy" name="author" />
      <title>FreshCart</title>
      <link href="<?php echo e(asset('assets/libs/tiny-slider/dist/tiny-slider.css')); ?>" rel="stylesheet" />
      <link href="<?php echo e(asset('assets/libs/slick-carousel/slick/slick.css')); ?>" rel="stylesheet" />
      <link href="<?php echo e(asset('assets/libs/slick-carousel/slick/slick-theme.css')); ?>" rel="stylesheet" />
      <!-- Favicon icon-->
      <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('assets/images/favicon/favicon.ico')); ?>" />

      <!-- Libs CSS -->
      <link href="<?php echo e(asset('assets/libs/bootstrap-icons/font/bootstrap-icons.min.css')); ?>" rel="stylesheet" />
      <link href="<?php echo e(asset('assets/libs/feather-webfont/dist/feather-icons.css')); ?>" rel="stylesheet" />
      <link href="<?php echo e(asset('assets/libs/simplebar/dist/simplebar.min.css')); ?>" rel="stylesheet" />

      <!-- Theme CSS -->
      <link rel="stylesheet" href="<?php echo e(asset('assets/css/theme.min.css')); ?>" />
      <script async src="https://www.googletagmanager.com/gtag/js?id=G-M8S4MT3EYG"></script>
      <script>
         window.dataLayer = window.dataLayer || [];
         function gtag() {
            dataLayer.push(arguments);
         }
         gtag("js", new Date());

         gtag("config", "G-M8S4MT3EYG");
      </script>
      <script type="text/javascript">
         (function (c, l, a, r, i, t, y) {
            c[a] =
               c[a] ||
               function () {
                  (c[a].q = c[a].q || []).push(arguments);
               };
            t = l.createElement(r);
            t.async = 1;
            t.src = "https://www.clarity.ms/tag/" + i;
            y = l.getElementsByTagName(r)[0];
            y.parentNode.insertBefore(t, y);
         })(window, document, "clarity", "script", "kuc8w5o9nt");
      </script>
   </head>

   <body>
      <!-- navigation -->
      <header>
         <div class="container">
            <div class="row align-items-center pt-2">
               <div class="col-xl-3 col-lg-8 col-7 d-flex">
                  <div class="dropdown selectBox">
                     <a class="dropdown-toggle selectValue text-reset" href="javascript:void(0)" data-bs-toggle="dropdown" aria-expanded="false">BDT ৳</a>

                     <ul class="dropdown-menu">
                        
                        <li><a class="dropdown-item" href="javascript:void(0)">BDT ৳</a></li>
                     </ul>
                  </div>
                  <div class="ms-6">
                     <div class="dropdown selectBox">
                        <a class="dropdown-toggle selectValue text-reset" href="javascript:void(0)" data-bs-toggle="dropdown" aria-expanded="false">English</a>

                        <ul class="dropdown-menu">
                           <li><a class="dropdown-item" href="javascript:void(0)">English</a></li>
                           <li><a class="dropdown-item" href="javascript:void(0)">Bangla</a></li>
                        </ul>
                     </div>
                  </div>
               </div>

               <div class="col-xl-9 col-lg-4 col-5 d-md-flex align-items-center justify-content-end">
                  <a href="#" class="text-reset">Support</a>
                  <a href="#" class="mx-md-8 ms-4 text-reset">Delivery</a>
                  <a href="#" class="text-reset d-none d-md-block">Warranty</a>
                  <!-- Button -->
               </div>
            </div>
            <div class="row align-items-center pt-6 pb-4 mt-4 mt-lg-0">
               <div class="col-xl-2 col-md-3 mb-4 mb-md-0 col-12 text-center text-md-start">
                  <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('assets/images/logo/freshcart-logo.svg')); ?>" alt="eCommerce Freshcart" /></a>
               </div>

               <div class="col-xxl-6 col-xl-5 col-lg-6 col-md-9">
                  <form action="<?php echo e(route('search')); ?>" method="GET">
                     <div class="input-group position-relative">
                        <input class="form-control" type="search" name="q" id="searchInput" placeholder="Search for products" value="<?php echo e(request('q')); ?>" aria-label="Search products" aria-describedby="button-addon2" autocomplete="off" />
                        <button class="btn btn-primary" type="submit" id="button-addon2">Search</button>
                        <div id="searchSuggestions" class="position-absolute w-100 bg-white border rounded shadow-sm" style="top: 100%; z-index: 1000; display: none; max-height: 300px; overflow-y: auto;"></div>
                     </div>
                  </form>
               </div>
               <div class="col-xxl-4 col-xl-5 col-lg-3 d-none d-lg-block">
                  <div class="d-flex align-items-center justify-content-between ms-4">
                     <div class="text-center">
                        <div class="dropdown">
                           <a href="#" class="text-reset" data-bs-toggle="dropdown" aria-expanded="false">
                              <div class="lh-1">
                                 <div class="position-relative d-inline-block mb-2">
                                    <i class="bi bi-bell fs-4"></i>
                                    <?php if(Auth::check() && $notifications->where('read_at', null)->count() > 0): ?>
                                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                       <?php echo e($notifications->where('read_at', null)->count()); ?>

                                       <span class="visually-hidden">unread notifications</span>
                                    </span>
                                    <?php endif; ?>
                                 </div>
                                 <p class="mb-0 d-none d-xl-block small">Notification</p>
                              </div>
                           </a>

                           <div class="dropdown-menu dropdown-menu-end" style="width: 350px; max-height: 400px; overflow-y: auto;">
                              <div class="d-flex justify-content-between align-items-center px-3 py-2 border-bottom">
                                 <h6 class="mb-0 fw-bold">Notifications</h6>
                                 <?php if(Auth::check() && $notifications->where('read_at', null)->count() > 0): ?>
                                 <small class="text-primary"><?php echo e($notifications->where('read_at', null)->count()); ?> new</small>
                                 <?php endif; ?>
                              </div>
                              <?php if(Auth::check() && $notifications->count() > 0): ?>
                                 <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                 <div class="notification-item px-3 py-2 border-bottom <?php echo e($notification->read_at ? '' : 'bg-light'); ?>" 
                                      data-notification-id="<?php echo e($notification->id); ?>" 
                                      style="cursor: pointer;">
                                    <div class="d-flex align-items-start">
                                       <div class="me-2 mt-1">
                                          <?php if($notification->type == 'order'): ?>
                                             <i class="bi bi-bag-check text-success"></i>
                                          <?php elseif($notification->type == 'deal'): ?>
                                             <i class="bi bi-tag text-warning"></i>
                                          <?php elseif($notification->type == 'product'): ?>
                                             <i class="bi bi-box text-info"></i>
                                          <?php else: ?>
                                             <i class="bi bi-info-circle text-primary"></i>
                                          <?php endif; ?>
                                       </div>
                                       <div class="flex-grow-1">
                                          <div class="fw-semibold small"><?php echo e($notification->title); ?></div>
                                          <div class="text-muted small"><?php echo e(Str::limit($notification->message, 60)); ?></div>
                                          <div class="text-muted" style="font-size: 11px;"><?php echo e($notification->created_at->diffForHumans()); ?></div>
                                       </div>
                                       <?php if(!$notification->read_at): ?>
                                       <div class="ms-2">
                                          <span class="badge bg-primary rounded-pill" style="width: 8px; height: 8px; padding: 0;"></span>
                                       </div>
                                       <?php endif; ?>
                                    </div>
                                 </div>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 <div class="text-center py-2">
                                    <a href="#" class="text-decoration-none small">View all notifications</a>
                                 </div>
                              <?php else: ?>
                                 <div class="text-center py-4">
                                    <i class="bi bi-bell-slash text-muted" style="font-size: 2rem;"></i>
                                    <div class="text-muted mt-2">No notifications yet</div>
                                    <?php if(auth()->guard()->guest()): ?>
                                    <div class="small text-muted mt-1">
                                       <a href="<?php echo e(route('login')); ?>">Sign in</a> to see your notifications
                                    </div>
                                    <?php endif; ?>
                                 </div>
                              <?php endif; ?>
                           </div>
                        </div>
                     </div>
                     <div class="ms-6 text-center">
                        <?php if(auth()->guard()->check()): ?>
                        <div class="dropdown">
                           <a href="#" class="text-reset" data-bs-toggle="dropdown" aria-expanded="false">
                              <div class="lh-1">
                                 <div class="mb-2">
                                    <i class="bi bi-person-circle fs-4"></i>
                                 </div>
                                 <p class="mb-0 d-none d-xl-block small">Profile</p>
                              </div>
                           </a>
                           <div class="dropdown-menu dropdown-menu-end">
                              <a class="dropdown-item" href="<?php echo e(route('profile.edit')); ?>">Profile Settings</a>
                              <div class="dropdown-divider"></div>
                              <form method="POST" action="<?php echo e(route('logout')); ?>">
                                 <?php echo csrf_field(); ?>
                                 <button type="submit" class="dropdown-item">Logout</button>
                              </form>
                           </div>
                        </div>
                        <?php else: ?>
                        <div class="dropdown">
                           <a href="#" class="text-reset" data-bs-toggle="dropdown" aria-expanded="false">
                              <div class="lh-1">
                                 <div class="mb-2">
                                    <i class="bi bi-person-circle fs-4"></i>
                                 </div>
                                 <p class="mb-0 d-none d-xl-block small">Account</p>
                              </div>
                           </a>
                           <div class="dropdown-menu dropdown-menu-end">
                              <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#loginModal">Sign In</a>
                              <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#userModal">Sign Up</a>
                           </div>
                        </div>
                        <?php endif; ?>
                     </div>
                     <div class="ms-6 text-center">
                        <?php if(auth()->guard()->check()): ?>
                        <a href="<?php echo e(route('my-orders')); ?>" class="text-reset">
                           <div class="lh-1">
                              <div class="mb-2">
                                 <i class="bi bi-archive fs-4"></i>
                              </div>
                              <p class="mb-0 d-none d-xl-block small">My Orders</p>
                           </div>
                        </a>
                        <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>" class="text-reset">
                           <div class="lh-1">
                              <div class="mb-2">
                                 <i class="bi bi-archive fs-4"></i>
                              </div>
                              <p class="mb-0 d-none d-xl-block small">My Orders</p>
                           </div>
                        </a>
                        <?php endif; ?>
                     </div>
                     <div class="text-center ms-6">
                        <a data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" href="#offcanvasExample" role="button" aria-controls="offcanvasRight" class="text-reset">
                           <div class="text-center">
                              <div>
                                 <i class="bi bi-cart2 fs-4"></i>
                              </div>
                              <p class="mb-0 d-none d-xl-block small">Shopping Cart</p>
                           </div>
                        </a>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </header>

      <nav class="navbar navbar-expand-lg navbar-light navbar-default p-0 p-sm-0 navbar-offcanvas-color" aria-label="Offcanvas navbar large">
         <div class="container">
            <div class="offcanvas offcanvas-start" tabindex="-1" id="navbar-default" aria-labelledby="navbar-defaultLabel">
               <div class="offcanvas-header pb-1">
                  <a href="index.html"><img src="<?php echo e(asset('assets/images/logo/freshcart-logo.svg')); ?>" alt="eCommerce HTML Template" /></a>
                  <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
               </div>
               <div class="offcanvas-body">
                  <div>
                     <ul class="navbar-nav align-items-center">
                        <li class="dropdown me-6 d-none d-lg-block">
                           <a href="#" class="text-inherit" data-bs-toggle="dropdown" aria-expanded="false">
                              <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-text-left me-2" viewBox="0 0 16 16">
                                 <path
                                    fill-rule="evenodd"
                                    d="M2 12.5a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm0-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5zm0-3a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7a.5.5 0 0 1-.5-.5zm0-3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z"></path>
                              </svg>
                              All Category
                           </a>

                           <ul class="dropdown-menu dropdown-menu-lg">
                              <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <li class="dropdown-menu-list">
                                 <a href="javascript:void(0)" class="dropdown-item d-flex justify-content-between mb-1 py-1">
                                    <div>
                                       <span class="ms-1"><?php echo e($category->name); ?><?php if($category->brand): ?> (<?php echo e($category->brand->name); ?>)<?php endif; ?></span>
                                    </div>
                                    <?php if($category->subcategories->count() > 0): ?>
                                    <div>
                                       <i class="feather-icon icon-chevron-right"></i>
                                    </div>
                                    <?php endif; ?>
                                 </a>

                                 <?php if($category->subcategories->count() > 0): ?>
                                 <div class="dropdown-menu-list-submenu">
                                    <div>
                                       <ul class="list-unstyled">
                                          <?php $__currentLoopData = $category->subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <li>
                                             <a href="javascript:void(0)" class="dropdown-item"><?php echo e($subcategory->name); ?></a>
                                          </li>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                       </ul>
                                    </div>
                                 </div>
                                 <?php endif; ?>
                              </li>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           </ul>
                        </li>
                        <li class="nav-item">
                           <a class="nav-link" href="<?php echo e(route('home')); ?>">Home</a>
                        </li>
                        <li class="nav-item">
                           <a class="nav-link" href="<?php echo e(route('shop-all')); ?>">Shop</a>
                        </li>
                        <li class="nav-item">
                           <a class="nav-link" href="<?php echo e(route('all-store')); ?>">Store</a>
                        </li>
                     </ul>
                  </div>
               </div>
            </div>
         </div>
      </nav>

      <!-- Shop Cart -->

      <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
         <div class="offcanvas-header border-bottom">
            <div class="text-start">
               <h5 id="offcanvasRightLabel" class="mb-0 fs-4">Shop Cart</h5>
               <small>Get Discount by Add More</small>
            </div>
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
         </div>
         <div class="offcanvas-body">
            <div>
               <!-- alert -->
               <div class="alert alert-danger p-2" role="alert">
                  You’ve got FREE delivery. Start
                  <a href="<?php echo e(route('shop-checkout')); ?>" class="alert-link">checkout now!</a>
               </div>
               <ul class="list-group list-group-flush" id="cartItems">
                  <!-- Dynamic cart items will be loaded here -->
               </ul>
               <!-- Total -->
               <div class="border-top pt-3 mt-3">
                  <div class="d-flex justify-content-between">
                     <span class="fw-bold">Total:</span>
                     <span class="fw-bold" id="cartTotal">৳0.00</span>
                  </div>
               </div>
               <!-- btn -->
               <div class="d-flex justify-content-between mt-4">
                  <a href="" class="btn btn-primary">Continue Shopping</a>
                  <a href="<?php echo e(route('shop-checkout')); ?>" class="btn btn-dark">Checkout</a>
               </div>
            </div>
         </div>
      </div>
      <!-- Modal -->
      <div class="modal fade" id="userModal" tabindex="-1" aria-labelledby="userModalLabel" aria-hidden="true">
         <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content p-4">
               <div class="modal-header border-0">
                  <h5 class="modal-title fs-3 fw-bold" id="userModalLabel">Sign Up</h5>

                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
               </div>
               <div class="modal-body">
                  <form>
                     <div class="mb-3">
                        <label for="fullName" class="form-label">Name</label>
                        <input type="text" class="form-control" id="fullName" placeholder="Enter Your Name" required="" />
                     </div>
                     <div class="mb-3">
                        <label for="email" class="form-label">Email address</label>
                        <input type="email" class="form-control" id="email" placeholder="Enter Email address" required="" />
                     </div>

                     <div class="mb-5">
                        <label for="password" class="form-label">Password</label>
                        <input type="password" class="form-control" id="password" placeholder="Enter Password" required="" />
                        <small class="form-text">
                           By Signup, you agree to our
                           <a href="javascript:void(0)">Terms of Service</a>
                           &
                           <a href="javascript:void(0)">Privacy Policy</a>
                        </small>
                     </div>

                     <button type="submit" class="btn btn-primary">Sign Up</button>
                  </form>
               </div>
               <div class="modal-footer border-0 justify-content-center">
                  Already have an account?
                  <a href="#" data-bs-dismiss="modal" data-bs-toggle="modal" data-bs-target="#loginModal">Sign in</a>
               </div>
            </div>
         </div>
      </div>

      <!-- Sign In Modal -->
      <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
         <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content p-4">
               <div class="modal-header border-0">
                  <h5 class="modal-title fs-3 fw-bold" id="loginModalLabel">Sign In</h5>
                  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
               </div>
               <div class="modal-body">
                  <form method="POST" action="<?php echo e(route('login')); ?>">
                     <?php echo csrf_field(); ?>
                     <div class="mb-3">
                        <label for="loginEmail" class="form-label">Email address</label>
                        <input type="email" class="form-control" id="loginEmail" name="email" placeholder="Enter Email address" required />
                     </div>
                     <div class="mb-5">
                        <label for="loginPassword" class="form-label">Password</label>
                        <input type="password" class="form-control" id="loginPassword" name="password" placeholder="Enter Password" required />
                        <div class="d-flex justify-content-between mt-2">
                           <div class="form-check">
                              <input class="form-check-input" type="checkbox" name="remember" id="remember">
                              <label class="form-check-label" for="remember">Remember me</label>
                           </div>
                           <a href="<?php echo e(route('password.request')); ?>" class="small">Forgot Password?</a>
                        </div>
                     </div>
                     <button type="submit" class="btn btn-primary w-100">Sign In</button>
                  </form>
               </div>
               <div class="modal-footer border-0 justify-content-center">
                  Don't have an account?
                  <a href="#" data-bs-dismiss="modal" data-bs-toggle="modal" data-bs-target="#userModal">Sign up</a>
               </div>
            </div>
         </div>
      </div>

      <div class="bg-white position-fixed bottom-0 w-100 z-1 shadow-lg d-block d-lg-none text-center">
         <div class="d-flex align-items-center">
            <div class="w-25 icon-hover py-4">
               <!-- Button -->
               <button
                  class="navbar-toggler collapsed d-lg-none"
                  type="button"
                  data-bs-toggle="offcanvas"
                  data-bs-target="#navbar-default"
                  aria-controls="navbar-default"
                  aria-expanded="false"
                  aria-label="Toggle navigation">
                  <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-text-indent-left text-primary" viewBox="0 0 16 16">
                     <path
                        d="M2 3.5a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5zm.646 2.146a.5.5 0 0 1 .708 0l2 2a.5.5 0 0 1 0 .708l-2 2a.5.5 0 0 1-.708-.708L4.293 8 2.646 6.354a.5.5 0 0 1 0-.708zM7 6.5a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 3a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5zm-5 3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z" />
                  </svg>
               </button>
            </div>

            <div class="dropdown w-25 ms-2 py-4 icon-hover">
               <a href="#" class="text-inherit" data-bs-toggle="dropdown" aria-expanded="false">
                  <div class="text-center">
                     <div class="position-relative d-inline-block">
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-bell" viewBox="0 0 16 16">
                           <path
                              d="M8 16a2 2 0 0 0 2-2H6a2 2 0 0 0 2 2zM8 1.918l-.797.161A4.002 4.002 0 0 0 4 6c0 .628-.134 2.197-.459 3.742-.16.767-.376 1.566-.663 2.258h10.244c-.287-.692-.502-1.49-.663-2.258C12.134 8.197 12 6.628 12 6a4.002 4.002 0 0 0-3.203-3.92L8 1.917zM14.22 12c.223.447.481.801.78 1H1c.299-.199.557-.553.78-1C2.68 10.2 3 6.88 3 6c0-2.42 1.72-4.44 4.005-4.901a1 1 0 1 1 1.99 0A5.002 5.002 0 0 1 13 6c0 .88.32 4.2 1.22 6z" />
                        </svg>
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                           1
                           <span class="visually-hidden">unread messages</span>
                        </span>
                     </div>
                  </div>
               </a>

               <div class="dropdown-menu dropdown-menu-lg p-0">
                  <div>
                     <h6 class="px-4 border-bottom py-3 mb-0">Notification</h6>
                     <p class="mb-0 px-4 py-3">
                        <a href="signin.html">Sign in</a>
                        or
                        <a href="signup.html">Register</a>
                        in or so you don t have to enter your details every time
                     </p>
                  </div>
               </div>
            </div>

            <div class="w-25 ms-2 py-4 icon-hover">
               <a href="javascript:void(0)" class="text-inherit" data-bs-toggle="modal" data-bs-target="#userModal">
                  <div class="text-center">
                     <div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-person-circle" viewBox="0 0 16 16">
                           <path d="M11 6a3 3 0 1 1-6 0 3 3 0 0 1 6 0z" />
                           <path fill-rule="evenodd" d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8zm8-7a7 7 0 0 0-5.468 11.37C3.242 11.226 4.805 10 8 10s4.757 1.225 5.468 2.37A7 7 0 0 0 8 1z" />
                        </svg>
                     </div>
                  </div>
               </a>
            </div>
            <div class="w-25 ms-2 py-4 icon-hover">
               <a href="account-orders.html" class="text-inherit">
                  <div class="text-center">
                     <div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-archive" viewBox="0 0 16 16">
                           <path
                              d="M0 2a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a2.5 2.5 0 0 1-2.5 2.5h-9A2.5 2.5 0 0 1 1 12.5V5a1 1 0 0 1-1-1V2zm2 3v7.5A1.5 1.5 0 0 0 3.5 14h9a1.5 1.5 0 0 0 1.5-1.5V5H2zm13-3H1v2h14V2zM5 7.5a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5z" />
                        </svg>
                     </div>
                  </div>
               </a>
            </div>
            <div class="w-25 ms-2 py-4 icon-hover">
               <a data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" href="#offcanvasExample" role="button" aria-controls="offcanvasRight" class="text-inherit">
                  <div class="text-center">
                     <div>
                        <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-cart2" viewBox="0 0 16 16">
                           <path
                              d="M0 2.5A.5.5 0 0 1 .5 2H2a.5.5 0 0 1 .485.379L2.89 4H14.5a.5.5 0 0 1 .485.621l-1.5 6A.5.5 0 0 1 13 11H4a.5.5 0 0 1-.485-.379L1.61 3H.5a.5.5 0 0 1-.5-.5zM3.14 5l1.25 5h8.22l1.25-5H3.14zM5 13a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm-2 1a2 2 0 1 1 4 0 2 2 0 0 1-4 0zm9-1a1 1 0 1 0 0 2 1 1 0 0 0 0-2zm-2 1a2 2 0 1 1 4 0 2 2 0 0 1-4 0z" />
                        </svg>
                     </div>
                  </div>
               </a>
            </div>
            <div class="w-25 ms-2 py-4 icon-hover">
               <a class="text-inherit" data-bs-toggle="offcanvas" href="#offcanvasCategory" role="button" aria-controls="offcanvasCategory">
                  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-funnel" viewBox="0 0 16 16">
                     <path
                        d="M1.5 1.5A.5.5 0 0 1 2 1h12a.5.5 0 0 1 .5.5v2a.5.5 0 0 1-.128.334L10 8.692V13.5a.5.5 0 0 1-.342.474l-3 1A.5.5 0 0 1 6 14.5V8.692L1.628 3.834A.5.5 0 0 1 1.5 3.5v-2zm1 .5v1.308l4.372 4.858A.5.5 0 0 1 7 8.5v5.306l2-.666V8.5a.5.5 0 0 1 .128-.334L13.5 3.308V2h-11z" />
                  </svg>
               </a>
            </div>
         </div>
      </div>

        <?php echo $__env->yieldContent('content'); ?>

      <!-- Modal -->
      <div class="modal fade" id="quickViewModal" tabindex="-1" aria-hidden="true">
         <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content">
               <div class="modal-body p-8">
                  <div class="position-absolute top-0 end-0 me-3 mt-3">
                     <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <div class="row">
                     <div class="col-lg-6">
                        <!-- img slide -->
                        <div class="product productModal" id="productModal">
                           <div class="zoom" onmousemove="zoom(event)" style="background-image: url(<?php echo e(asset('assets/images/products/product-single-img-1.jpg')); ?>)">
                              <!-- img -->
                              <img src="<?php echo e(asset('assets/images/products/product-single-img-1.jpg')); ?>" alt="" />
                           </div>
                           <div>
                              <div class="zoom" onmousemove="zoom(event)" style="background-image: url(<?php echo e(asset('assets/images/products/product-single-img-2.jpg')); ?>)">
                                 <!-- img -->
                                 <img src="<?php echo e(asset('assets/images/products/product-single-img-2.jpg')); ?>" alt="" />
                              </div>
                           </div>
                           <div>
                              <div class="zoom" onmousemove="zoom(event)" style="background-image: url(<?php echo e(asset('assets/images/products/product-single-img-3.jpg')); ?>)">
                                 <!-- img -->
                                 <img src="<?php echo e(asset('assets/images/products/product-single-img-3.jpg')); ?>" alt="" />
                              </div>
                           </div>
                           <div>
                              <div class="zoom" onmousemove="zoom(event)" style="background-image: url(<?php echo e(asset('assets/images/products/product-single-img-4.jpg')); ?>)">
                                 <!-- img -->
                                 <img src="<?php echo e(asset('assets/images/products/product-single-img-4.jpg')); ?>" alt="" />
                              </div>
                           </div>
                        </div>
                        <!-- product tools -->
                        <div class="product-tools">
                           <div class="thumbnails row g-3" id="productModalThumbnails">
                              <div class="col-3" class="tns-nav-active">
                                 <div class="thumbnails-img">
                                    <!-- img -->
                                    <img src="<?php echo e(asset('assets/images/products/product-single-img-1.jpg')); ?>" alt="" />
                                 </div>
                              </div>
                              <div class="col-3">
                                 <div class="thumbnails-img">
                                    <!-- img -->
                                    <img src="<?php echo e(asset('assets/images/products/product-single-img-2.jpg')); ?>" alt="" />
                                 </div>
                              </div>
                              <div class="col-3">
                                 <div class="thumbnails-img">
                                    <!-- img -->
                                    <img src="<?php echo e(asset('assets/images/products/product-single-img-3.jpg')); ?>" alt="" />
                                 </div>
                              </div>
                              <div class="col-3">
                                 <div class="thumbnails-img">
                                    <!-- img -->
                                    <img src="<?php echo e(asset('assets/images/products/product-single-img-4.jpg')); ?>" alt="" />
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="col-lg-6">
                        <div class="ps-lg-8 mt-6 mt-lg-0">
                           <a href="#!" class="mb-4 d-block">Bakery Biscuits</a>
                           <h2 class="mb-1 h1">Napolitanke Ljesnjak</h2>
                           <div class="mb-4">
                              <small class="text-warning">
                                 <i class="bi bi-star-fill"></i>
                                 <i class="bi bi-star-fill"></i>
                                 <i class="bi bi-star-fill"></i>
                                 <i class="bi bi-star-fill"></i>
                                 <i class="bi bi-star-half"></i>
                              </small>
                              <a href="#" class="ms-2">(30 reviews)</a>
                           </div>
                           <div class="fs-4">
                              <span class="fw-bold text-dark">৳32</span>
                              <span class="text-decoration-line-through text-muted">৳35</span>
                              <span><small class="fs-6 ms-2 text-danger">26% Off</small></span>
                           </div>
                           <hr class="my-6" />
                           <div class="mb-4">
                              <button type="button" class="btn btn-outline-secondary">250g</button>
                              <button type="button" class="btn btn-outline-secondary">500g</button>
                              <button type="button" class="btn btn-outline-secondary">1kg</button>
                           </div>
                           <div>
                              <!-- input -->
                              <!-- input -->
                              <div class="input-group input-spinner">
                                 <input type="button" value="-" class="button-minus btn btn-sm" data-field="quantity" />
                                 <input type="number" step="1" max="10" value="1" name="quantity" class="quantity-field form-control-sm form-input" />
                                 <input type="button" value="+" class="button-plus btn btn-sm" data-field="quantity" />
                              </div>
                           </div>
                           <div class="mt-3 row justify-content-start g-2 align-items-center">
                              <div class="col-lg-4 col-md-5 col-6 d-grid">
                                 <!-- button -->
                                 <!-- btn -->
                                 <button type="button" class="btn btn-primary">
                                    <i class="feather-icon icon-shopping-bag me-2"></i>
                                    Add to cart
                                 </button>
                              </div>
                              <div class="col-md-4 col-5">
                                 <!-- btn -->
                                 <a class="btn btn-light" href="#" data-bs-toggle="tooltip" data-bs-html="true" aria-label="Compare"><i class="bi bi-arrow-left-right"></i></a>
                                 <a class="btn btn-light" href="#!" data-bs-toggle="tooltip" data-bs-html="true" aria-label="Wishlist"><i class="feather-icon icon-heart"></i></a>
                              </div>
                           </div>
                           <hr class="my-6" />
                           <div>
                              <table class="table table-borderless">
                                 <tbody>
                                    <tr>
                                       <td>Product Code:</td>
                                       <td>FBB00255</td>
                                    </tr>
                                    <tr>
                                       <td>Availability:</td>
                                       <td>In Stock</td>
                                    </tr>
                                    <tr>
                                       <td>Type:</td>
                                       <td>Fruits</td>
                                    </tr>
                                    <tr>
                                       <td>Shipping:</td>
                                       <td>
                                          <small>
                                             01 day shipping.
                                             <span class="text-muted">( Free pickup today)</span>
                                          </small>
                                       </td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>

      <!-- Footer -->
      <!-- footer -->
      <footer class="footer bg-dark pb-6 pt-4 pt-md-12">
         <div class="container">
            <div class="row align-items-center">
               <div class="col-8 col-md-12 col-lg-4">
                  <a href="#"><img src="<?php echo e(asset('assets/images/logo/freshcart-white-logo.svg')); ?>" alt="" /></a>
               </div>
               <div class="col-4 col-md-12 col-lg-8 text-end">
                  <ul class="list-inline text-md-end mb-0 small">
                     <li class="list-inline-item me-2">
                        <a href="#!" class="social-links">
                           <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                              <path
                                 d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951z" />
                           </svg>
                        </a>
                     </li>
                     <li class="list-inline-item me-2">
                        <a href="#!" class="social-links">
                           <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-twitter" viewBox="0 0 16 16">
                              <path
                                 d="M5.026 15c6.038 0 9.341-5.003 9.341-9.334 0-.14 0-.282-.006-.422A6.685 6.685 0 0 0 16 3.542a6.658 6.658 0 0 1-1.889.518 3.301 3.301 0 0 0 1.447-1.817 6.533 6.533 0 0 1-2.087.793A3.286 3.286 0 0 0 7.875 6.03a9.325 9.325 0 0 1-6.767-3.429 3.289 3.289 0 0 0 1.018 4.382A3.323 3.323 0 0 1 .64 6.575v.045a3.288 3.288 0 0 0 2.632 3.218 3.203 3.203 0 0 1-.865.115 3.23 3.23 0 0 1-.614-.057 3.283 3.283 0 0 0 3.067 2.277A6.588 6.588 0 0 1 .78 13.58a6.32 6.32 0 0 1-.78-.045A9.344 9.344 0 0 0 5.026 15z" />
                           </svg>
                        </a>
                     </li>
                     <li class="list-inline-item">
                        <a href="#!" class="social-links">
                           <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-instagram" viewBox="0 0 16 16">
                              <path
                                 d="M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.917 3.917 0 0 0-1.417.923A3.927 3.927 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.916 3.916 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.926 3.926 0 0 0-.923-1.417A3.911 3.911 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 7.998 0h.003zm-.717 1.442h.718c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599.28.28.453.546.598.92.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.47 2.47 0 0 1-.599.919c-.28.28-.546.453-.92.598-.28.11-.704.24-1.485.276-.843.038-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.485-.276a2.478 2.478 0 0 1-.92-.598 2.48 2.48 0 0 1-.6-.92c-.109-.281-.24-.705-.275-1.485-.038-.843-.046-1.096-.046-3.233 0-2.136.008-2.388.046-3.231.036-.78.166-1.204.276-1.486.145-.373.319-.64.599-.92.28-.28.546-.453.92-.598.282-.11.705-.24 1.485-.276.738-.034 1.024-.044 2.515-.045v.002zm4.988 1.328a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92zm-4.27 1.122a4.109 4.109 0 1 0 0 8.217 4.109 4.109 0 0 0 0-8.217zm0 1.441a2.667 2.667 0 1 1 0 5.334 2.667 2.667 0 0 1 0-5.334z" />
                           </svg>
                        </a>
                     </li>
                  </ul>
               </div>
            </div>
            <hr class="my-lg-8 opacity-25" />
            <div class="row g-4">
               <div class="col-12 col-md-12 col-lg-4">
                  <h6 class="mb-4 text-white">Categories</h6>
                  <div class="row">
                     <div class="col-6">
                        <!-- list -->
                        <ul class="nav flex-column">
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Vegetables & Fruits</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Breakfast & instant food</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Bakery & Biscuits</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Atta, rice & dal</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Sauces & spreads</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Organic & gourmet</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Baby care</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Cleaning essentials</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Personal care</a></li>
                        </ul>
                     </div>
                     <div class="col-6">
                        <!-- list -->
                        <ul class="nav flex-column">
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Dairy, bread & eggs</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Cold drinks & juices</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Tea, coffee & drinks</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Masala, oil & more</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Chicken, meat & fish</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Paan corner</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Pharma & wellness</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Home & office</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Pet care</a></li>
                        </ul>
                     </div>
                  </div>
               </div>
               <div class="col-12 col-md-12 col-lg-8">
                  <div class="row g-4">
                     <div class="col-6 col-sm-6 col-md-3">
                        <h6 class="mb-4 text-white">Get to know us</h6>
                        <!-- list -->
                        <ul class="nav flex-column">
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Company</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">About</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Blog</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Help Center</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Our Value</a></li>
                        </ul>
                     </div>
                     <div class="col-6 col-sm-6 col-md-3">
                        <h6 class="mb-4 text-white">For Consumers</h6>
                        <ul class="nav flex-column">
                           <!-- list -->
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Payments</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Shipping</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Product Returns</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">FAQ</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Shop Checkout</a></li>
                        </ul>
                     </div>
                     <div class="col-6 col-sm-6 col-md-3">
                        <h6 class="mb-4 text-white">Become a Shopper</h6>
                        <ul class="nav flex-column">
                           <!-- list -->
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Shopper Opportunities</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Become a Shopper</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Earnings</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Ideas & Guides</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">New Retailers</a></li>
                        </ul>
                     </div>
                     <div class="col-6 col-sm-6 col-md-3">
                        <h6 class="mb-4 text-white">Freshcart programs</h6>
                        <ul class="nav flex-column">
                           <!-- list -->
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Freshcart programs</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Gift Cards</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Promos & Coupons</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Freshcart Ads</a></li>
                           <li class="nav-item mb-2"><a href="#!" class="nav-link">Careers</a></li>
                        </ul>
                     </div>
                  </div>
               </div>
            </div>
            <hr class="mt-8 opacity-25" />
            <div>
               <div class="row gy-4 align-items-center">
                  <div class="col-md-6">
                     <span class="small text-muted">
                        © 2022
                        <span id="copyright">
                           -
                           <script>
                              document.getElementById("copyright").appendChild(document.createTextNode(new Date().getFullYear()));
                           </script>
                        </span>
                        FreshCart eCommerce HTML Template. All rights reserved. Powered by
                        <a href="https://codescandy.com/">Codescandy</a>
                        .
                     </span>
                  </div>
                  <div class="col-lg-6 text-end mb-2 mb-lg-0">
                     <ul class="list-inline mb-0">
                        <li class="list-inline-item text-light">Payment Partners</li>
                        <li class="list-inline-item">
                           <a href="#!"><img src="<?php echo e(asset('assets/images/payment/amazonpay.svg')); ?>" alt="" /></a>
                        </li>
                        <li class="list-inline-item">
                           <a href="#!"><img src="<?php echo e(asset('assets/images/payment/american-express.svg')); ?>" alt="" /></a>
                        </li>
                        <li class="list-inline-item">
                           <a href="#!"><img src="<?php echo e(asset('assets/images/payment/mastercard.svg')); ?>" alt="" /></a>
                        </li>
                        <li class="list-inline-item">
                           <a href="#!"><img src="<?php echo e(asset('assets/images/payment/paypal.svg')); ?>" alt="" /></a>
                        </li>
                        <li class="list-inline-item">
                           <a href="#!"><img src="<?php echo e(asset('assets/images/payment/visa.svg')); ?>" alt="" /></a>
                        </li>
                     </ul>
                  </div>
               </div>
            </div>
         </div>
      </footer>

      <!-- Javascript-->
      <!-- Libs JS -->
      <!-- <script src="<?php echo e(asset('assets/libs/jquery/dist/jquery.min.js')); ?>"></script> -->
      <script src="<?php echo e(asset('assets/libs/bootstrap/dist/js/bootstrap.bundle.min.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/libs/simplebar/dist/simplebar.min.js')); ?>"></script>

      <!-- Theme JS -->
      <script src="<?php echo e(asset('assets/js/theme.min.js')); ?>"></script>

      <script src="<?php echo e(asset('assets/js/vendors/jquery.min.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/libs/slick-carousel/slick/slick.min.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/js/vendors/slick-slider.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/libs/tiny-slider/dist/min/tiny-slider.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/js/vendors/tns-slider.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/js/vendors/zoom.js')); ?>"></script>

      <script src="<?php echo e(asset('assets/js/vendors/countdown.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/libs/sticky-sidebar/dist/sticky-sidebar.min.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/js/vendors/sticky.js')); ?>"></script>
      <script src="<?php echo e(asset('assets/js/vendors/modal.js')); ?>"></script>
      
      <?php echo $__env->yieldPushContent('scripts'); ?>
      
      <script>
      // Global cart functions
      window.loadCartItems = function() {
          fetch('<?php echo e(route('cart.items')); ?>')
          .then(response => response.json())
          .then(cart => {
              const cartContainer = document.getElementById('cartItems');
              if (!cartContainer) return;
              
              if (Object.keys(cart).length === 0) {
                  cartContainer.innerHTML = '<li class="list-group-item text-center py-4"><p class="mb-0 text-muted">Your cart is empty</p></li>';
                  const cartTotal = document.getElementById('cartTotal');
                  if (cartTotal) cartTotal.textContent = '৳0.00';
                  return;
              }
              
              let total = 0;
              cartContainer.innerHTML = Object.entries(cart).map(([id, item]) => {
                  const itemTotal = item.price * item.quantity;
                  total += itemTotal;
                  const displayName = item.weight ? `${item.name} (${item.weight})` : item.name;
                  return `
                  <li class="list-group-item py-3 ps-0 border-top">
                      <div class="row align-items-center">
                          <div class="col-6 col-md-6 col-lg-7">
                              <div class="d-flex">
                                  <img src="${item.image ? '<?php echo e(asset('storage/')); ?>/' + item.image : '<?php echo e(asset('assets/images/products/product-img-1.jpg')); ?>'}" alt="${item.name}" class="icon-shape icon-xxl" />
                                  <div class="ms-3">
                                      <h6 class="mb-0">${displayName}</h6>
                                      <span><small class="text-muted">৳${item.price}</small></span>
                                      <div class="mt-2 small lh-1">
                                          <a href="#!" class="text-decoration-none text-inherit" onclick="removeFromCart('${id}')">
                                              <span class="me-1 align-text-bottom">
                                                  <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 text-success">
                                                      <polyline points="3 6 5 6 21 6"></polyline>
                                                      <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                                      <line x1="10" y1="11" x2="10" y2="17"></line>
                                                      <line x1="14" y1="11" x2="14" y2="17"></line>
                                                  </svg>
                                              </span>
                                              <span class="text-muted">Remove</span>
                                          </a>
                                      </div>
                                  </div>
                              </div>
                          </div>
                          <div class="col-4 col-md-3 col-lg-3">
                              <div class="input-group input-spinner">
                                  <input type="button" value="-" class="button-minus btn btn-sm" onclick="updateQuantity('${id}', ${item.quantity - 1})" />
                                  <input type="number" step="1" min="1" value="${item.quantity}" class="quantity-field form-control-sm form-input text-center" onchange="updateQuantity('${id}', this.value)" />
                                  <input type="button" value="+" class="button-plus btn btn-sm" onclick="updateQuantity('${id}', ${item.quantity + 1})" />
                              </div>
                          </div>
                          <div class="col-2 text-lg-end text-start text-md-end col-md-2">
                              <span class="fw-bold">৳${itemTotal.toFixed(2)}</span>
                          </div>
                      </div>
                  </li>
              `;
              }).join('');
              
              const cartTotal = document.getElementById('cartTotal');
              if (cartTotal) cartTotal.textContent = `৳${total.toFixed(2)}`;
          });
      };
      
      window.updateQuantity = function(cartKey, quantity) {
          if (quantity < 1) return;
          
          fetch('<?php echo e(route('cart.update')); ?>', {
              method: 'POST',
              headers: {
                  'Content-Type': 'application/json',
                  'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
              },
              body: JSON.stringify({ 
                  product_id: cartKey, 
                  quantity: parseInt(quantity) 
              })
          })
          .then(response => response.json())
          .then(data => {
              if (data.success) {
                  window.loadCartItems();
              } else {
                  alert(data.message);
              }
          });
      };
      
      window.removeFromCart = function(cartKey) {
          fetch('<?php echo e(route('cart.remove')); ?>', {
              method: 'POST',
              headers: {
                  'Content-Type': 'application/json',
                  'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
              },
              body: JSON.stringify({ product_id: cartKey })
          })
          .then(response => response.json())
          .then(data => {
              if (data.success) {
                  window.loadCartItems();
              }
          });
      };
      
      document.addEventListener('DOMContentLoaded', function() {
          const searchInput = document.getElementById('searchInput');
          const suggestions = document.getElementById('searchSuggestions');
          let timeout;
          
          if (searchInput && suggestions) {
              searchInput.addEventListener('input', function() {
                  clearTimeout(timeout);
                  const query = this.value.trim();
                  
                  if (query.length < 2) {
                      suggestions.style.display = 'none';
                      return;
                  }
                  
                  timeout = setTimeout(() => {
                      fetch('/api/suggestions?q=' + encodeURIComponent(query))
                          .then(response => response.json())
                          .then(data => {
                              if (data.length > 0) {
                                  suggestions.innerHTML = data.map(item => 
                                      '<div class="p-3 border-bottom suggestion-item d-flex justify-content-between align-items-center" style="cursor: pointer;" data-name="' + item.name + '" data-id="' + item.id + '">' +
                                          '<div>' +
                                              '<div class="fw-bold text-dark">' + item.name + '</div>' +
                                              '<small class="text-muted">' + (item.brand ? item.brand + ' • ' : '') + item.category + '</small>' +
                                          '</div>' +
                                          '<div class="text-end">' +
                                              '<span class="fw-bold text-primary">৳' + item.price + '</span>' +
                                          '</div>' +
                                      '</div>'
                                  ).join('');
                                  suggestions.style.display = 'block';
                                  
                                  document.querySelectorAll('.suggestion-item').forEach(item => {
                                      item.addEventListener('click', function() {
                                          const productName = this.dataset.name;
                                          const productId = this.dataset.id;
                                          searchInput.value = productName;
                                          suggestions.style.display = 'none';
                                          window.location.href = '/product/' + productId;
                                      });
                                  });
                              } else {
                                  suggestions.innerHTML = '<div class="p-3 text-muted text-center">No products found</div>';
                                  suggestions.style.display = 'block';
                                  setTimeout(() => suggestions.style.display = 'none', 2000);
                              }
                          })
                          .catch(error => {
                              console.error('Search error:', error);
                              suggestions.style.display = 'none';
                          });
                  }, 300);
              });
              
              document.addEventListener('click', function(e) {
                  if (!searchInput.contains(e.target) && !suggestions.contains(e.target)) {
                      suggestions.style.display = 'none';
                  }
              });
          }
          
          // Load cart items on page load
          window.loadCartItems();
          
          // Notification functionality
          document.querySelectorAll('.notification-item').forEach(item => {
              item.addEventListener('click', function() {
                  const notificationId = this.dataset.notificationId;
                  if (notificationId && !this.classList.contains('read')) {
                      fetch(`/notifications/${notificationId}/read`, {
                          method: 'POST',
                          headers: {
                              'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                          }
                      })
                      .then(response => response.json())
                      .then(data => {
                          if (data.success) {
                              this.classList.remove('bg-light');
                              const badge = this.querySelector('.badge');
                              if (badge) badge.remove();
                              
                              // Update notification count
                              const countBadge = document.querySelector('.bi-bell + .badge');
                              if (countBadge) {
                                  const currentCount = parseInt(countBadge.textContent);
                                  if (currentCount > 1) {
                                      countBadge.textContent = currentCount - 1;
                                  } else {
                                      countBadge.remove();
                                  }
                              }
                          }
                      });
                  }
              });
          });
      });
      </script>
   </body>

<!-- Mirrored from freshcart.codescandy.com/pages/index-5.html by HTTrack Website Copier/3.x [XR&CO'2014], Tue, 06 May 2025 11:01:18 GMT -->
</html>
<?php /**PATH E:\wampserver\www\localworks\chefschoicebd\resources\views/frontend/home.blade.php ENDPATH**/ ?>